/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.vo.MosPVo;
import jp.mosp.system.dto.MCodeDto;

public class CodeMasterCardVo extends MosPVo {

	private static final long serialVersionUID = 7743759495787416910L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL	= "/jsp/system/codeMasterCard.jsp";
	private static final String EXTRA_JS		= "/pub/system/js/codeMasterCard.js";
	private static final String EXTRA_CSS		= "/pub/system/css/codeMasterCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_CODE_MASTER;

	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;
	public static final int MODE_SYSTEM = 2;

	// p[^
	public static final String PRM_PLT_T_ID		= "pltTId";
	public static final String PRM_TXT_T_CODE		= "txtTCode";
	public static final String PRM_TXT_T_NAME		= "txtTName";
	public static final String PRM_TXT_T_CHANGE	= "txtTChange";

	// tB[h
	private String	pltTId;
	private String	txtTCode;
	private String	txtTName;
	private String	txtTChange;

	// v_EXg
	public String[][] aryPltTId;

	// [h(0FVKo^A1FXVA2F폜)
	private int mode;

	// tB[hyѐ
	public static final String NAM_CODE_ID	= CommonConst.NAM_TABLE;
	public static final String NAM_CODE		= CommonConst.NAM_COMMON_CODE;
	public static final String NAM_NAME		= CommonConst.NAM_COMMON_MEISYO;
	public static final String NAM_CHANGE		= CommonConst.NAM_CONVERSION; 		//ϊ

	public static final int	LEN_CODE		= 9;
	public static final int	LEN_NAME		= 25;
	public static final int	LEN_CHANGE		= 25;

	/**
	 * RXgN^
	 */
	public CodeMasterCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		pltTId		= request.getParameter(PRM_PLT_T_ID);
		txtTCode	= request.getParameter(PRM_TXT_T_CODE);
		txtTName	= request.getParameter(PRM_TXT_T_NAME);
		txtTChange	= request.getParameter(PRM_TXT_T_CHANGE);
	}

	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(MCodeDto dto) {
		// f[^̐ݒ
		pltTId		= dto.getTId();
		txtTCode	= dto.getTCode();
		txtTName	= dto.getTName();
		txtTChange	= dto.getTChange();
	}

	/**
	 * tB[h̑ÓmF
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws MospException
	 */
	public void validate(boolean isInsert) throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(pltTId	, NAM_CODE_ID	, PRM_PLT_T_ID		);
		checkRequired(txtTCode	, NAM_CODE		, PRM_TXT_T_CODE	);
		// 񒷊mF
		checkLength  (txtTCode	, LEN_CODE		, NAM_CODE		, PRM_TXT_T_CODE	);
		checkLength  (txtTName	, LEN_NAME		, NAM_NAME		, PRM_TXT_T_NAME	);
		checkLength  (txtTChange, LEN_CHANGE	, NAM_CHANGE	, PRM_TXT_T_CHANGE	);
		// ÓmFI
		endValidation();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MCodeDto dto) {
		dto.setTId(pltTId);
		dto.setTCode(txtTCode);
		dto.setTName(txtTName);
		dto.setTChange(txtTChange);
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public void setPltTId		(String pltTId		) { this.pltTId		= pltTId	; }
	public void setTxtTCode	(String txtTCode	) { this.txtTCode	= txtTCode	; }
	public void setTxtTName	(String txtTName	) { this.txtTName	= txtTName	; }
	public void setTxtTChange	(String txtTChange	) { this.txtTChange	= txtTChange; }

	public String getPltTId			() { return pltTId		; }
	public String getTxtTCode		() { return txtTCode	; }
	public String getTxtTName		() { return txtTName	; }
	public String getTxtTChange		() { return txtTChange	; }

	public String getEscPltTId		() { return escapeHTML(pltTId)		; }
	public String getEscTxtTCode	() { return escapeHTML(txtTCode)	; }
	public String getEscTxtTName	() { return escapeHTML(txtTName)	; }
	public String getEscTxtTChange	() { return escapeHTML(txtTChange)	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
